#include "g_local.h"
// NCD: PowerAI_CheckTeam
// will return which team this guy is on in integer form (1=dragons, 2=nikki)
int PowerAI_CheckTeam (edict_t * ent)
{
	if (ent->client)
		return ent->client->pers.team;
	else
		return ent->power_mod_team;
}

// NCD: PowerAI_CheckTeamIFF
// returns
//	0 for not applicable (someone is neutral)
//	1 for the same team
//	2 for differnet teams
int PowerAI_CheckTeamIFF (edict_t *self, edict_t *other)
{
	// affiliated and on same team
	if ( (PowerAI_CheckTeam(self)==1) && (PowerAI_CheckTeam(other)==1) )
		return 1;
	if ( (PowerAI_CheckTeam(self)==2) && (PowerAI_CheckTeam(other)==2) )
		return 1;

	// affiliated but on different teams
	if ( (PowerAI_CheckTeam(self)==1) && (PowerAI_CheckTeam(other)==2) )
		return 2;
	if ( (PowerAI_CheckTeam(self)==2) && (PowerAI_CheckTeam(other)==1) )
		return 2;

	// if either is neutral (unaffliiated)
	return 0;
}

// NCD: Remove Someone from everyone's memory
// the idea is to make this function remove it's argument from everyone's memory
// this function might not be needes
void PowerAI_RemoveFromMemory (edict_t *ent)
{
	int i;
	if (ent == NULL)
		return;

	for ( i = 0; i < level.num_characters; i++ )
	{
//		if (level.characters[i] == NULL)
//			continue;
		if (level.characters[i])
		{
			AI_RemoveFromMemory(level.characters[i], ent->cast_info.friend_memory);
			AI_RemoveFromMemory(level.characters[i], ent->cast_info.neutral_memory);
			AI_RemoveFromMemory(level.characters[i], ent->cast_info.enemy_memory);
		}
	}
}




void AI_MakeFriendly ( edict_t *self, edict_t *other)
{
	cast_memory_t *cast_memory;
	cast_memory = level.global_cast_memory[self->character_index][other->character_index];

	// if you attack the ai this will make them friendly again
	// but until they shift out of attack mode they'll keep attacking you
	// getting out of their line of sight should make them friendly again.

	if (cast_memory->memory_type != MEMORY_TYPE_FRIEND)
	{
		//if (other->client)
		//	gi.dprintf("\ndebug: %s is on the same team as %s",self->name,other->client->pers.netname);
		//else
		//	gi.dprintf("\ndebug%s is on the same team as %s",self->name,other->name);

		AI_RemoveFromMemory( self, cast_memory );
		AI_AddToMemory ( self, cast_memory, MEMORY_TYPE_FRIEND );

	}

	//cast_memory->flags |= memory_flags;
	//cast_memory->flags |= MEMORY_HOSTILE_ENEMY;
}











